﻿var vocab = {
	"Collections": [
		{"id":"hatier-barem-cycle4","title":"BaREM - Hatier","imgPrefix":"barem_hatier","cmsUrl":"http://barem-hatier.fr","levels":["http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-621"],"teachingAreas":["http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-947"],"themes":["Nombres et calculs","Utiliser les nombres pour comparer, calculer et résoudre des problèmes","Comprendre et utiliser les notions de divisibilité et de nombres premiers","Utiliser le calcul littéral","Organisation et gestion de données, fonctions","Interpréter, représenter et traiter des données","Comprendre et utiliser des notions élémentaires de probabilités","Résoudre des problèmes de proportionnalité","Comprendre et utiliser la notion de fonction","Grandeurs et mesures","Calculer avec des grandeurs mesurables "," exprimer les résultats dans les unités adaptées","Comprendre l’effet de quelques transformations sur des grandeurs géométriques","Espace et géométrie","Représenter l’espace","Utiliser les notions de géométrie plane pour démontrer","Algorithmique et programmation","Écrire, mettre au point et exécuter un programme simple"]},
		{"id":"hatier-blick-klick-cycle4","title":"Blick & Klick - Hatier","imgPrefix":"bnk_hatier","cmsUrl":"http://blickundklick-hatier.fr","levels":["tactileo-level-cecrl"],"detailedLevels":["http://purl.org/net/inloc/cefr/cefr-A1","http://purl.org/net/inloc/cefr/cefr-A2","http://purl.org/net/inloc/cefr/cefr-B1"],"teachingAreas":["http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1623"],"skills":[""],"themes":["Aussehen","Cyberspace","Essen","Familie & Freunde","Feiern","Freizeit","Geschichte","Identität & Integration","Kunst","Reisen","Schule","Sich vorstellen","Umwelt","Wissenschaft","Wohnen"]},
		{"id":"maskott-sciences-cycle4","title":"Maskott Sciences","imgPrefix":"maskott_sciences","cmsUrl":"http://sciences.maskott.com","levels":["http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-621"],"teachingAreas":["http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1496","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1511","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1534"]}
	],
	"Levels": [
		{"id":"tactileo-level-c1","title":"Cycle 1 : cycle d'apprentissages premiers","titleShort":"Cycle 1","isRoot":false,"detailedLevels":["http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-005","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-006","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-007"],"teachingAreas":["http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1286","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1291","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1308","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1315","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1274"]},
		{"id":"tactileo-level-c2","title":"Cycle 2 : cycle des apprentissages fondamentaux","titleShort":"Cycle 2","isRoot":false,"detailedLevels":["http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-010","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-011","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-013"],"teachingAreas":["http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1033","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1549","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1110","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1334","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1431","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-920","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-968"]},
		{"id":"tactileo-level-c3","title":"Cycle 3 : cycle de consolidation","titleShort":"Cycle 3","isRoot":false,"detailedLevels":["http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-014","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-015","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-018"],"teachingAreas":["http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1056","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1576","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1120","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1357","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-981","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-934","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1474","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1622","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1627","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1634","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1635","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1636","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1628","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1637","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1638","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1624","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1629","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1625","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1630","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1640","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1631","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1626","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1632","","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1639","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1623","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1633"]},
		{"id":"tactileo-level-c4","title":"Cycle 4 : cycle des approfondissements","titleShort":"Cycle 4","isRoot":false,"detailedLevels":["http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-020","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-021","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-023"],"teachingAreas":["http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1180","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-903","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1201","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1084","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1600","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1391","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1229","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1007","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-947","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1496","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1511","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1534","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-915","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-917","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-916","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-911","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-912","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-918","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-914","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-913","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1622","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1627","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1634","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1635","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1636","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1628","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1637","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1638","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1624","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1629","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1625","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1630","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1640","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1631","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1626","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1632","","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1639","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1623","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1633"]},
		{"id":"tactileo-level-lycee","title":"Lycée","isRoot":false,"detailedLevels":["http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-025","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-028","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-039"],"teachingAreas":["http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-130","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-636","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-638","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1838","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-134","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-012","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-013","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-640","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-652","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-028","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1839","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1840","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-036","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-642","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-040","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1841","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-660","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1847","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1848","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-644","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-050","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-051","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-649","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1843","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-059","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-060","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-656","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1845","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-068","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-070","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-650","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-658","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-004","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1851","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1852","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1853","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-002","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-143","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-079","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-009","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-145","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-010","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-011","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1854","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-014","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-015","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-016","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-017","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-018","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-152","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-142","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-019","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-021","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-022","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-023","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-025","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-027","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-147","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-156","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-149","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-144","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-151","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-137","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-032","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-138","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-135","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-155","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-139","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-146","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-685","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-148","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-034","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-136","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-033","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1855","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-078","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-080","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-157","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-140","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-132","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-131","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-154","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-037","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-038","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-039","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1856","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1842","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-043","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-141","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-045","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1857","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-093","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1846","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1850","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1849","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-052","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-645","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-647","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-053","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-159","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-055","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-056","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-057","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-150","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-058","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-153","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1844","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1858","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-062","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-081","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-082","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-064","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1859","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-065","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-066","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-067","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-071","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-072","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-083","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-073","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-075","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-076","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-133"]},
		{"id":"tactileo-level-cecrl","title":"CECRL : Cadre européen commun de référence pour les langues","titleShort":"CECRL","isFilterable":"false","isRoot":false,"detailedLevels":["A1","A1 > A2","A2 > B1"],"teachingAreas":["http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1639","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1623","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1633","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1622","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1627","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1634","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1635","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1636","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1628","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1637","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1638","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1624","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1629","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1625","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1630","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1640","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1631","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1626","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1632"]},
		{"id":"http://data.education.fr/voc/scolomfr/concept/other","title":"Autres","isRoot":true},
		
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-617","title":"Cycle 1 : cycle d'apprentissages premiers","titleShort":"Cycle 1","isRoot":true},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-005","title":"Cycle 1 > Petite section","isRoot":true},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-006","title":"Cycle 1 > Moyenne section","isRoot":true},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-007","title":"Cycle 1 > Grande section","isRoot":true},
		
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-619","title":"Cycle 2 : cycle des apprentissages fondamentaux","titleShort":"Cycle 2","isRoot":true},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-010","title":"Cycle 2 > CP","isRoot":true},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-011","title":"Cycle 2 > CE1","isRoot":true},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-013","title":"Cycle 2 > CE2","isRoot":true},

		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-012","title":"Cycle 3 : cycle de consolidation","titleShort":"Cycle 3","isRoot":true},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-014","title":"Cycle 3 > CM1","isRoot":true},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-015","title":"Cycle 3 > CM2","isRoot":true},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-018","title":"Cycle 3 > 6e","isRoot":true},

		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-621","title":"Cycle 4 : cycle des approfondissements","titleShort":"Cycle 4","isRoot":true},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-020","title":"Cycle 4 > 5e","isRoot":true},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-021","title":"Cycle 4 > 4e","isRoot":true},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-023","title":"Cycle 4 > 3e","isRoot":true},

		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-142","title":"Lycée","isRoot":true},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-025","title":"Lycée > 2de","isRoot":true},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-028","title":"Lycée > 1ère","isRoot":true},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-022-num-039","title":"Lycée > Terminale","isRoot":true},

		{"id":"Parcours A1","title":"Parcours A1","isRoot":true},
		{"id":"Parcours A1 > Parcours A2","title":"Parcours A1 > A2","isRoot":true},
		{"id":"Parcours A2 > Parcours B1","title":"Parcours A2 > B1","isRoot":true},
	],
	"TeachingAreas": [
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1286","title":"agir, s'exprimer, comprendre à travers l'activité physique (cycle 1)","cssClass":"sports_leisure","imgPrefix":"sport"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1291","title":"agir, s'exprimer, comprendre à travers les activités artistiques (cycle 1)","cssClass":"arts","imgPrefix":"art"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1180","title":"arts plastiques (cycle 4)","cssClass":"arts","imgPrefix":"art"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1308","title":"construire les premiers outils pour structurer sa pensée (cycle 1)","cssClass":"science_nature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-903","title":"éducation aux médias et à l'information (cycle 4)","cssClass":"history_citizenship","imgPrefix":"earth"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1201","title":"éducation musicale (cycle 4)","cssClass":"arts","imgPrefix":"music"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1033","title":"éducation physique et sportive (cycle 2)","cssClass":"sports_leisure","imgPrefix":"sport"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1056","title":"éducation physique et sportive (cycle 3)","cssClass":"sports_leisure","imgPrefix":"sport"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1084","title":"éducation physique et sportive (cycle 4)","cssClass":"sports_leisure","imgPrefix":"sport"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1549","title":"enseignement moral et civique (cycle 2)","cssClass":"history_citizenship","imgPrefix":"civic"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1576","title":"enseignement moral et civique (cycle 3)","cssClass":"history_citizenship","imgPrefix":"civic"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1600","title":"enseignement moral et civique (cycle 4)","cssClass":"history_citizenship","imgPrefix":"civic"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1110","title":"enseignements artistiques (cycle 2)","cssClass":"arts","imgPrefix":"art"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1120","title":"enseignements artistiques (cycle 3)","cssClass":"arts","imgPrefix":"art"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1315","title":"explorer le monde (cycle 1)","cssClass":"geography","imgPrefix":"earth"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1334","title":"français (cycle 2)","cssClass":"literature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1357","title":"français (cycle 3)","cssClass":"literature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1391","title":"français (cycle 4)","cssClass":"literature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1229","title":"histoire des arts (cycle 4)","cssClass":"arts","imgPrefix":"art"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-981","title":"histoire et géographie (cycle 3)","cssClass":"geography","imgPrefix":"earth"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1007","title":"histoire et géographie (cycle 4)","cssClass":"geography","imgPrefix":"earth"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1431","title":"langues vivantes étrangères ou régionales (cycle 2)","cssClass":"literature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-920","title":"mathématiques (cycle 2)","cssClass":"science_nature","imgPrefix":"maths"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-934","title":"mathématiques (cycle 3)","cssClass":"science_nature","imgPrefix":"maths"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-947","title":"mathématiques (cycle 4)","cssClass":"science_nature","imgPrefix":"maths"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1274","title":"mobiliser le langage dans toutes ses dimensions (cycle 1)","cssClass":"literature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1496","title":"physique-chimie (cycle 4)","cssClass":"literature","imgPrefix":"chemistry"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-968","title":"questionner le monde (cycle 2) (discipline)","cssClass":"geography","imgPrefix":"earth"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1511","title":"sciences de la vie et de la Terre (cycle 4)","cssClass":"science_nature","imgPrefix":"biology"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1474","title":"sciences et technologie (cycle 3)","cssClass":"science_nature","imgPrefix":"tech"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1534","title":"technologie (cycle 4)","cssClass":"sports_leisure","imgPrefix":"tech"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-915","title":"EPI cycle 4 : corps, santé, bien-être et sécurité","cssClass":"science_nature","imgPrefix":"biology"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-917","title":"EPI cycle 4 : culture et création artistiques","cssClass":"arts","imgPrefix":"art"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-916","title":"EPI cycle 4 : information, communication, citoyenneté","cssClass":"history_citizenship","imgPrefix":"civic"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-911","title":"EPI cycle 4 : langues et cultures de l’Antiquité","cssClass":"literature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-912","title":"EPI cycle 4 : langues et cultures étrangères / régionales","cssClass":"literature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-918","title":"EPI cycle 4 : monde économique et professionnel","cssClass":"history_citizenship","imgPrefix":"earth"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-914","title":"EPI cycle 4 : sciences, technologie et société","cssClass":"science_nature","imgPrefix":"earth"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-913","title":"EPI cycle 4 : transition écologique et développement durable","cssClass":"science_nature","imgPrefix":"earth"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1639","title":"Guyane (langues régionales de la) (LVER)","cssClass":"literature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1623","title":"allemand (LVER)","cssClass":"literature","imgPrefix":"german"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1633","title":"alsacien et langues des pays mosellans (LVER)","cssClass":"literature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1622","title":"anglais (LVER)","cssClass":"literature","imgPrefix":"english"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1627","title":"arabe (LVER)","cssClass":"literature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1634","title":"basque (LVER)","cssClass":"literature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1635","title":"breton (LVER)","cssClass":"literature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1636","title":"catalan (LVER)","cssClass":"literature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1628","title":"chinois (LVER)","cssClass":"literature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1637","title":"corse (LVER)","cssClass":"literature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1638","title":"créole (LVER)","cssClass":"literature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1624","title":"espagnol (LVER)","cssClass":"literature","imgPrefix":"spanish"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1629","title":"hébreu (LVER)","cssClass":"literature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1625","title":"italien (LVER)","cssClass":"literature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1630","title":"néerlandais (LVER)","cssClass":"literature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1640","title":"occitan (LVER)","cssClass":"literature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1631","title":"polonais (LVER)","cssClass":"literature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1626","title":"portugais (LVER)","cssClass":"literature","imgPrefix":"literature"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-015-num-1632","title":"russe (LVER)","cssClass":"literature","imgPrefix":"literature"}
	],
	"Skills": [
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00715","title":"1 : les langages pour penser et communiquer","isRoot":true,"detailedSkills":["http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00718","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00719","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00716","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00717"]},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00720","title":"2 : les méthodes et outils pour apprendre","isRoot":true,"detailedSkills":["http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00721","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00724","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00722","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00723"]},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00725","title":"3 : la formation de la personne et du citoyen","isRoot":true,"detailedSkills":["http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00727","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00728","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00726","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00729"]},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00730","title":"4 : les systèmes naturels et les systèmes techniques","isRoot":true,"detailedSkills":["http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00732","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00733","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00731"]},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00734","title":"5 : les représentations du monde et l’activité humaine","isRoot":true,"detailedSkills":["http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00736","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00735","http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00737"]},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00718","title":"1.3 : comprendre, s’exprimer en utilisant les langages mathématiques, scientifiques et informatiques"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00719","title":"1.4 : comprendre, s’exprimer en utilisant les langages des arts et du corps"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00716","title":"1.1 : comprendre, s’exprimer en utilisant la langue française à l’oral et à l’écrit"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00717","title":"1.2 : comprendre, s’exprimer en utilisant une langue étrangère ou régionale"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00721","title":"2.1 : organisation du travail personnel"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00724","title":"2.4 : outils numériques pour échanger et communiquer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00722","title":"2.2 : coopération et réalisation de projets"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00723","title":"2.3 : médias, démarches de recherche et de traitement de l’information"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00727","title":"3.2 : la règle et le droit"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00728","title":"3.3 : réflexion et discernement"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00726","title":"3.1 : expression de la sensibilité et des opinions, respect des autres"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00729","title":"3.4 : responsabilité, sens de l’engagement et de l’initiative"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00732","title":"4.2 : conception, création, réalisation d’objets et systèmes techniques"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00733","title":"4.3 : responsabilités individuelles et collectives"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00731","title":"4.1 : démarches scientifiques"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00736","title":"5.2 : organisation et représentations du monde"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00735","title":"5.1 : l’espace et le temps"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-016-num-00737","title":"5.3 : invention, élaboration, production d’objets culturels"}
	],
	"Difficulties": [
		{"id":"http://data.education.fr/voc/scolomfr/concept/difficult","title":"difficile"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/medium","title":"moyen"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/easy","title":"facile"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/very_difficult","title":"très difficile"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/very_easy","title":"très facile"}
	],
	"LearningResourceTypes": [
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-010-num-001","title":"animation"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-010-num-023","title":"annales"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/self_assessment","title":"autoévaluation"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/lecture","title":"cours / présentation"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-010-num-024","title":"cyberquête"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-010-num-004","title":"démonstration"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/problem_statement","title":"énoncé de problème"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-010-num-006","title":"étude de cas"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-010-num-007","title":"évaluation"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/exam","title":"examen"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/exercise","title":"exercice"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/experiment","title":"expérience"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-010-num-011","title":"glossaire"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-010-num-012","title":"guide"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-010-num-013","title":"jeu éducatif"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-010-num-014","title":"manuel d'enseignement"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-010-num-015","title":"matériel de référence"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-010-num-025","title":"méthode de langues"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-010-num-016","title":"méthodologie"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-010-num-017","title":"outil"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-010-num-018","title":"production d'élève"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/questionnaire","title":"questionnaire"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-010-num-020","title":"scénario pédagogique"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/simulation","title":"simulation"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-010-num-026","title":"témoignage pédagogique"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-010-num-022","title":"tutoriel"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-010-num-0082","title":"préparation à l'examen"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-010-num-027","title":"activité pédagogique"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-010-num-028","title":"fiche pédagogique"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-010-num-029","title":"diagnostic"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/table","title":"tableau"}
	],
	"IntendedEndUserRoles": [
		{"id":"http://data.education.fr/voc/scolomfr/concept/learner","title":"apprenant"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/author_2","title":"auteur"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/teacher","title":"enseignant"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/manager","title":"gestionnaire"}
	],
	"InducedActivities": [
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-001","title":"animer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-002","title":"apprendre"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-003","title":"collaborer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-004","title":"communiquer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-005","title":"coopérer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-006","title":"créer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-007","title":"échanger"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-019","title":"expérimenter"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-008","title":"lire"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-009","title":"observer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-010","title":"organiser"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-011","title":"produire"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-012","title":"publier"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-013","title":"rechercher"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-017","title":"se former"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-015","title":"s'évaluer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-016","title":"s'exercer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-018","title":"simuler"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-027","title":"s'informer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-021","title":"écouter"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-024","title":"jouer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-028","title":"tester"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-029","title":"visionner"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-030","title":"analyser"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-031","title":"argumenter"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-032","title":"calculer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-033","title":"caractériser"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-034","title":"citer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-035","title":"classer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-036","title":"comparer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-037","title":"comprendre"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-038","title":"compter"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-039","title":"construire des savoirs"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-040","title":"découvrir"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-041","title":"décrire"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-042","title":"dénombrer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-043","title":"dessiner"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-044","title":"discuter"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-045","title":"écrire"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-046","title":"exposer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-047","title":"expliquer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-048","title":"identifier"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-049","title":"illustrer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-050","title":"justifier"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-051","title":"montrer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-052","title":"parler"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-053","title":"présenter"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-054","title":"programmer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-055","title":"réaliser"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-056","title":"repérer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-057","title":"réprimer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-058","title":"résumer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-059","title":"réviser"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-060","title":"s'exprimer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-061","title":"structurer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-062","title":"synthétiser"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-063","title":"tracer"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-019-num-064","title":"trier"}
	],
	"EducationalMethods": [
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-001","title":"à distance"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-002","title":"en alternance"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-003","title":"en autonomie"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-004","title":"en classe entière"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-005","title":"en collaboration"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-007","title":"en entreprise"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-012","title":"en groupe"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-013","title":"en groupe de compétences"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-014","title":"en ligne"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-015","title":"en tutorat"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-016","title":"modalité mixte"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-017","title":"séjour pédagogique"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-019","title":"sortie pédagogique"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-021","title":"travail de recherche"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-022","title":"travail en interdisciplinarité"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-023","title":"travaux dirigés"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-024","title":"travaux pratiques"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-035","title":"en atelier"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-033","title":"séquence en atelier"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-032","title":"atelier théorique"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-030","title":"en activité de projet"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-009","title":"PFMP (période de formation en milieu professionnel)"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-010","title":"PFE (période de formation en entreprise)"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-039","title":"en stage"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-006","title":"étude dirigée"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-028","title":"aide didactique"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-011","title":"échange pédagogique de classes"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-018-num-040","title":"en compétition"}
	],
	"Tools" : [
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-007","title":"cahier de textes numérique"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-017","title":"environnement numérique de travail"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-020","title":"learning management system"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-044","title":"logiciel de simulation"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-075","title":"système de gestion de base de données"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-002","title":"agrégateur de contenu"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-003","title":"aide technique"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-029","title":"logiciel de création multimédia"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-036","title":"logiciel de manipulation d'images et de vidéos"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-043","title":"logiciel de reconnaissance et de synthèse vocales"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-071","title":"outil d'encodage"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-023","title":"logiciel d'aide à l'orientation"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-025","title":"logiciel d'application"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-032","title":"logiciel de fabrication assistée par ordinateur"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-045","title":"logiciel de traitement de son"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-067","title":"moteur de recherche"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-048","title":"logiciel de traitement d'enquête"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-031","title":"logiciel de développement d'application"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-069","title":"outil de mise en ligne"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-070","title":"outil de modélisation"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-051","title":"logiciel de travail collaboratif"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-055","title":"logiciel documentaire"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-145","title":"logiciel de visualisation et de lecture de média"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-076","title":"système d'information géographique"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-141","title":"logiciel de lecture de livre numérique"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-147","title":"logiciel éditeur de texte"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-142","title":"logiciel de programmation"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-061","title":"logiciel système"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-146","title":"logiciel d'enseignement"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-052","title":"logiciel d'édition et de gestion d'exercices"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-028","title":"logiciel de communication et d'échange"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-004","title":"appareil photographique"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-008","title":"calculatrice"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-016","title":"enceintes"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-065","title":"microphone"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-066","title":"microscope"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-015","title":"écran tactile"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-012","title":"console de jeux"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-021","title":"liseuse"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-068","title":"ordinateur"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-077","title":"tableau blanc interactif"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-079","title":"téléphone"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-019","title":"imprimante"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-010","title":"casque audio"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-063","title":"machine-outil à commande numérique"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-072","title":"rétroprojecteur"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-078","title":"tablette"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-082","title":"webcam"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-005","title":"baladeur"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-006","title":"borne informatique"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-009","title":"caméra"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-011","title":"classe mobile"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-014","title":"documentation technique"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-073","title":"scanner"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-080","title":"vidéoprojecteur"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-081","title":"visualiseur"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-151","title":"stockage externe"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-138","title":"EIM"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-149","title":"robot programmable"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-150","title":"scanner 3D"},
		{"id":"http://data.education.fr/voc/scolomfr/concept/scolomfr-voc-020-num-139","title":"imprimante 3D"}
	]
}